/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWException;
import filenet.vw.base.VWString;

public final class VWTimeUnitType {
    private static final int MIN_TIMEUNIT_TYPE = 1;
    private static final int INTERVAL = -1;
    public static final int MINUTES = 1;
    public static final int HOURS = 2;
    public static final int DAYS = 3;
    public static final int WEEKS = 4;
    public static final int MONTHS = 5;
    public static final int YEARS = 6;
    private static final int MAX_TIMEUNIT_TYPE = 6;
    private static String[] LocalizedStrings = new String[]{new VWString("vw.api.VWTimeUnitTypeMinutes", "Minutes").toString(), new VWString("vw.api.VWTimeUnitTypeHours", "Hours").toString(), new VWString("vw.api.VWTimeUnitTypeDays", "Days").toString(), new VWString("vw.api.VWTimeUnitTypeWeeks", "Weeks").toString(), new VWString("vw.api.VWTimeUnitTypeMonths", "Months").toString(), new VWString("vw.api.VWTimeUnitTypeYears", "Years").toString()};

    public static String _get_FILE_DATE() {
        return "$Date:   09 Sep 2008 14:10:44  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   dsiegfried  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.14  $";
    }

    public static boolean isValid(int timeUnitType) {
        return timeUnitType >= 1 && timeUnitType <= 6;
    }

    public static String getLocalizedString(int timeUnitType) throws VWException {
        if (!VWTimeUnitType.isValid(timeUnitType)) {
            throw new VWException("vw.api.VWTimeUnitTypeBadInteger", "Integer form of the time unit type is invalid: {0}", String.valueOf(timeUnitType));
        }
        return LocalizedStrings[timeUnitType - 1];
    }
}

